function noResult(show = true) {
    clear();
    if(show) {
        $('.no-result').removeClass('hide');
    }else {
        $('.no-result').addClass('hide');
    }
}

function errorResult(show = true) {
    clear();
    if(show) {
        $('.error-result').removeClass('hide');
    }else {
        $('.error-result').addClass('hide');
    }
}

function loader(show = true) {
    clear();
    if(show) {
        $('.loader').removeClass('hide');
    }else {
        $('.loader').addClass('hide');
    }
}

function clear() {
    $('.single-news').remove();
}

function fromNow(date, nowDate = Date.now()) {
    const now = typeof nowDate === 'object' ? nowDate.getTime() : new Date(nowDate).getTime();
    const diff = now - (typeof date === 'object' ? date : new Date(date)).getTime();
    const diffAbs = Math.abs(diff);
    var sec_num = parseInt(diffAbs/1000, 10);
    var hours   = Math.floor(sec_num / 3600);
    var minutes = Math.floor((sec_num - (hours * 3600)) / 60);
    var seconds = sec_num - (hours * 3600) - (minutes * 60);

    let str = '';

    if(hours   !== 0) str += hours+'hr ';
    if(minutes !== 0) str += minutes+'min ';
    if(seconds !== 0) str += seconds+(seconds == '01' ? 'sec' : 'secs');

    return str;
}

function createSingleTag(icon, text) {
    return $('<div>').addClass('tag').html('<i class="'+icon+'"></i> '+text);
}

function cOpacity(perc) {
    return Math.tanh(perc*16*Math.PI);
}

function createCircle(v) {

    if(v >= 0) {
        color = 'rgb(0, 255, 0)';
    }else {
        color = 'rgb(255, 0, 0)';
        v = Math.abs(v);
    }

    return $('<span>').css({'background-color': color, 'opacity': cOpacity(v)});
}

function popupCenter(url, title, w, h) {

    const dualScreenLeft = window.screenLeft !==  undefined ? window.screenLeft : window.screenX;
    const dualScreenTop = window.screenTop !==  undefined   ? window.screenTop  : window.screenY;

    const width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
    const height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;

    const systemZoom = width / window.screen.availWidth;
    const left = (width - w) / 2 / systemZoom + dualScreenLeft
    const top = (height - h) / 2 / systemZoom + dualScreenTop
    const newWindow = window.open(url, title, 
      `
      scrollbars=yes,
      width=${w / systemZoom}, 
      height=${h / systemZoom}, 
      top=${top}, 
      left=${left}
      `
    );

    if (window.focus) newWindow.focus();
}

function getText(news) {
    return `${news.title}, ${fromNow(news.publishedAt)} ago
$SPX ${news.esf} $NDX ${news.nqf} $DJIA ${news.djia} $OIL ${news.clf} #newsapp
${news.url}`;
}

function tweet(news) {
    popupCenter(
        "https://twitter.com/intent/tweet?text="+encodeURIComponent(getText(news)),
        "twitterwindow", 
        550, 550
    );
}

function createSingleItem(data) {
    let image = data.urlToImage == "" || data.urlToImage == null ? '/images/default.jpg' : data.urlToImage;
    let a = $('<a>').addClass('single-news').attr('href', data.url).attr('target', '_blank');
    let imageDiv = $('<div>').addClass('image').css('background-image', 'url('+image+')');

    let details = $('<div>').addClass('details');
    let top = $('<div>').addClass('top');
    let span = $('<span>').text(fromNow(data.publishedAt)+' ago').addClass('timestamp');

    setInterval(function () {
        span.text(fromNow(data.publishedAt)+' ago');
    }, 1000);

    let circles = $('<div>').addClass('circles');
    circles.append(createCircle(data.pc_spx));
    circles.append(createCircle(data.pc_nqf));
    circles.append(createCircle(data.pc_djia));
    circles.append(createCircle(data.pc_clf));

    top.append(circles);

    let more_s = $('<div>').addClass('more-s');
    more_s.append($('<span>').text('SPX '+data.esf));
    more_s.append($('<span>').text('NDX '+data.nqf));
    more_s.append($('<span>').text('DJIA '+data.djia));
    more_s.append($('<span>').text('OIL '+data.clf));

    details.append(top);
    details.append(more_s);
    details.append($('<h2>').addClass('title').text(data.title));
    
    if(data.description !== '' && data.description !== null) {
        details.append($('<p>').addClass('description').text(data.description));
    }
    
    details.append(span);

    let tags = $('<div>').addClass('tags');
    tags.append(createSingleTag('fas fa-globe-americas', data.country));
    tags.append(createSingleTag('fas fa-info-circle', data.source));

    let tweetBtn = createSingleTag('fab fa-twitter', data.tweet || 0).addClass('twitter-tag');
    tags.append(tweetBtn);
    tweetBtn.click(function (e) {
        e.preventDefault();
        tweet(data);
    });

    let copyBtn = createSingleTag('fas fa-share-alt', 'Share').addClass('share-tag');;
    tags.append(copyBtn);
    copyBtn.click(function(e) {
        e.preventDefault();
    });
    let clipboard = new ClipboardJS(copyBtn[0], {
        text: function(trigger) {
            console.log(trigger);
            return getText(data);
        }
    });

    clipboard.on('success', function(e) {
        copyBtn.html(copyBtn.html().replace('fa-share-alt', 'fa-copy').replace('Share', 'Copied!'));
        setTimeout(function () {
            copyBtn.html(copyBtn.html().replace('fa-copy', 'fa-share-alt').replace('Copied!', 'Share'));
        }, 700);
    });

    details.append(tags);
    a.append(details);
    a.append(imageDiv);
    return a;
}

function showData(data) {
    data.forEach(item => {
        $('.news-list').append(createSingleItem(item));
    });
}

function getData() {
    loader();

    $.ajax({
        url: '/api/news',
        type: 'GET',
    
        error: function() {
            loader(false);
            noResult(false);
            errorResult();
            console.log('error');
        },
        success: function(data) {
            loader(false);
            noResult(false);
            errorResult(false);

            if(data.length == 0) noResult();
            showData(data);
        }
    });
}

getData();
setInterval(getData, 120000);