<?php
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;
use Slim\Factory\AppFactory;
use Slim\Views\PhpRenderer;
use PHPHtmlParser\Dom;

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require __DIR__ . '/../vendor/autoload.php';
require __DIR__ . '/../lib/CURL.php';

define('TEMPLATES_DIR', __DIR__ . '/../templates');
define('AGENT', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36');

function getMeta($dom, $name) {
    $metaTags = $dom->find('meta');
    foreach ($metaTags as $metaTag) {
        if ($metaTag->getAttribute('property') == $name) {
            $val = $metaTag->getAttribute('content');
            return $val;
        }
    }
}

$app = AppFactory::create();
$renderer = new PhpRenderer(TEMPLATES_DIR);

$app->get('/', function (Request $request, Response $response, $args) use ($renderer) {
    return $renderer->render($response, 'news.php', $args);
});

$app->get('/stocks', function (Request $request, Response $response, $args) use ($renderer) {
    return $renderer->render($response, 'stocks.php', $args);
});

$app->get('/blog', function (Request $request, Response $response, $args) use ($renderer) {
    return $renderer->render($response, 'blog.php', $args);
});

//Endpoint

$host = 'https://iosapp.from-de.com:8090';

$app->get('/api/news', function (Request $request, Response $response, $args) use ($host) {
    
    $curl = CURL::getCURL();
    $endPoint = '/getWidgetMedium2';
    $dom = new Dom();

    $curl->setHeaders(['Accept' => 'application/json']);
    $data = $curl->get($host, $endPoint);

    if($data === NULL) {
        return $response->withStatus(500);
    }

    foreach($data as $i => $news) {
        if($news->source == 'BBxG') {
            unset($data[$i]);
        }else if($news->urlToImage == "" || $news->urlToImage == null) {
            $curl->setHeaders([]);
            $curl->setAgent(AGENT);
            $url = parse_url($news->url);
            $html = $curl->get($url['scheme'].'://'.$url['host'], $url['path']);
            $html = $dom->loadStr($html);
            $news->urlToImage = getMeta($html, 'og:image');
            $news->description = getMeta($html, 'og:description');
        }
    }

    $payload = json_encode($data);
    $response->getBody()->write($payload);
    return $response->withHeader('Content-Type', 'application/json');

});

$app->run();