<?php

class CURL {

    private static $inst = null;
    private $ch = null;
    private $headers = [];

    public static function getCURL() {
        if(!self::$inst) self::$inst = new CURL();
        return self::$inst;
    }

    private function __construct() {
        $this->create();
    }

    private function create() {
        $this->ch = curl_init();
        curl_setopt($this->ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($this->ch, CURLOPT_TIMEOUT, 30);
    }

    public function setHeaders(Array $headers) {
        $this->headers = $headers;

        $headers = array_map(function ($i, $v) { return $i.': '.$v; }, array_keys($headers), $headers);

        curl_setopt($this->ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($this->ch, CURLOPT_HEADER, 0);
    }

    public function setAgent(String $agent) {
        curl_setopt($this->ch, CURLOPT_USERAGENT, $agent);
    }

    public function get(String $host, String $url) {
        curl_setopt($this->ch, CURLOPT_URL, $host.$url);
        curl_setopt($this->ch, CURLOPT_CUSTOMREQUEST, "GET");
        $result = curl_exec($this->ch);

        if(isset($this->headers['Accept']) && $this->headers['Accept'] == 'application/json') {
            return json_decode($result);
        }
        return $result;
    }

}
